// File: applib.h
//
// Description: C++ header file for the Macintosh implementation
//              of the GUI library.  Parts of this file were
//              modeled after sample programs written by
//              Engineers at Apple Computer.
//
//              Set up for Symantec C++ version 6.0
//
// Copyright 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions. 
//       All source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts
//       all responsibility for its use.
//


#ifndef __applib
#define __applib

// We want to minimize the number of Mac specific include files
// in 'applib.h' to speed up compilation of application programs.

#include <Types.h>
#include <QuickDraw.h>
#include <Events.h>

//#include "apptypes.h"
#include <String.h>
#include <StdIO.h>

// #include <iostream.h>
//#include <stream.h>

#define output (ios::out)
#define input (ios::in)

#include "apcommon.h"

extern "C" { 
	void exit(int);
};

class TAppWindow;  // forward reference for the compiler


//
//        Class definition for TAppAPP application class
//

class Application {
 public:
	Application(void);
	void EventLoop(void);
	void DoMenuCommand(short menuID, short menuItem);

	static void set_TAppWindow(TAppWindow *aw) { fWindow = aw; }
	static TAppWindow * get_TAppWindow() { return fWindow; }
	
	enum {DIALOG_TEXT_LENGTH=128, DIALOG_MAX_LIST_ITEMS=64};
	
 	static char text_from_dialog[DIALOG_TEXT_LENGTH];
 	static int selection_from_dialog;
 	static char prompt_for_dialog[DIALOG_TEXT_LENGTH];
 	static char file_extension_for_dialog[DIALOG_TEXT_LENGTH];
 	static char * list_of_items_for_dialog[DIALOG_MAX_LIST_ITEMS];
 	static int number_of_dialog_list_items;
private:
	static TAppWindow *fWindow;	// The active window
};

#define TopLeft(aRect)	(* (Point *) &(aRect).top)
#define BotRight(aRect)	(* (Point *) &(aRect).bottom)
#define HiWrd(aLong)	((short) (((aLong) >> 16) & 0xFFFF))
#define LoWrd(aLong)	((short) ((aLong) & 0xFFFF))

// Increase this for large windows (> 32 lines of text):
const int MAX_TEXT_LINES = 32;

// Increase this for large windows (> 100 characters per line):
const int MAX_TEXT_LINE_SIZE = 100;


//
//                      Class definition for TAppWindow
//

class TAppWindow {
 protected:
	WindowPtr fDocWindow;
	
	// For scrolling text output:
	short top_text_clip, right_text_clip;
    short bottom_text_clip, left_text_clip;
	char *saved_text[MAX_TEXT_LINES];  // This is a ring-buffer
	int number_of_saved_lines;
	int current_ring_buffer_start;
	// We only allow either text or graphics to be active in
    // a document window.  The following flag is non-zero if
    // we are using the document window for scrolling text.
    // Note that this mode changes automatically when either
	// plotting or scrolling text output methods are called.
	int in_scrolling_text_mode;
	// The following flag indicates that a small scrolling 
    // text field is being used so we want to update both 
    // graphics and text. Note that this only looks good if
	// the application program is careful to not draw in the
    // scrolling text area.
	int redraw_both_text_and_graphics;

 private:
	void draw_update_contents(void);
	
 public:
	TAppWindow(short resID);
   ~TAppWindow(void);

	void DoContent(EventRecord* theEvent);
	void DoUpdate(void);
	
	void do_about();
	void do_edit(char *, char *);
	void show_info(char *);
	int choose_one(char *prompt1, char *prompt2);
	int choose_one_from_list(char *prompt, char **list_items,
							 int number_of_items);
	int choose_file_to_read(char *prompt, char * extension,
							char *returned_filename);
	int choose_file_to_write(char *prompt,
							 char *returned_filename);
	
	void init_scrolling_text(int top, int right,
							 int bottom, int left);
	void init_scrolling_text();
	void put_scrolling_text(char *str);
	void reset_scrolling_text();
	
	// Utility methods for application access:
	void plot_line(int, int, int, int);
	void plot_string(int, int, char *);
	void plot_rect(int top, int right, int bottom, int left);
	void plot_oval(int top, int right, int bottom, int left);
	void erase_rect(int top, int right, int bottom, int left);
	int  string_height(char *str);
	int  string_width(char *str);
	void clear_display();
	void redraw_display();
	// User specified methods:
	void update_display();
	void mouse_down(int, int);
	void mouse_up(int, int);
	void mouse_move(int, int);
	void do_menu_action(int);
	
	void idle_proc();
};


void Warning(char *);

// File selection utilities:
int choose_file_to_read(char *returned_filename,
						char *extension);  
           // 0 return -> OK, 1 return -> Failure

int choose_file_to_write(char *returned_filename);
          // 0 return -> OK, 1 return -> Failure

extern TAppWindow *current_window;

//
//   Macro definition for program initialization and startup
//

void setup_menus(char *, int, char **);

#define INIT_PROGRAM(name, num_items, items) \
Application *gTheApplication;\
int main(void)\
{ gTheApplication = new Application;\
  if (gTheApplication == nil)\
	  return 0;\
\
  current_window = (TAppWindow *)(Application::get_TAppWindow());\
  setup_menus(name, num_items, items);
	  

//
//   Macro definition for program execution
//

#define RUN_PROGRAM \
	gTheApplication->EventLoop();\
	return 0
	
#endif
